/********************************************************************
 * Copyright (c) 2011-18 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - threadstate.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
INT32 __stdcall GetThreadState(HANDLE hThread, HANDLE hEvent, UINT32 nTimeOut) {
BOOL		bQuit, bOK;
INT32		nState, nRet;
UINT32		nStart, nDelta;

	if (!hThread) return GTS_ENDED;
	if (!hEvent) return GTS_INVALID;
	bOK = bQuit = FALSE;
	if (nTimeOut) {
		SetEvent(hEvent);
		nStart = GetTickCount();
		do {
			Sleep(0);
			nState = WaitForSingleObject(hEvent, 0);
			if (nState == WAIT_OBJECT_0) {
				nDelta = GetTickCount() - nStart;
				if (nDelta >= nTimeOut) bQuit = TRUE;
			}
			else {
				bOK = bQuit = TRUE;
			}

		} while (!bQuit);
	}
	else {
		nState = WaitForSingleObject(hEvent, 0);
		if (nState != WAIT_OBJECT_0) {
			SetEvent(hEvent);
			bOK = TRUE;
		}
	}
	nRet = (bOK) ? GTS_ACTIVE : GTS_BUSY;
	return nRet;
}
