/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - truename.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include <lm.h>

// **********************************************************************************
// from Windows NT
//	#pragma comment(lib, "netapi32.lib")
//	nRes = NetShareGetInfo(wcServer, wcName, 2, (LPBYTE *) &InfoPtr);
// **********************************************************************************
typedef UINT32 (__stdcall* NT_INFOPROC)(LPWSTR lpServer, LPWSTR lpNet, UINT32 nLevel, LPBYTE *BufPtr);
typedef UINT32 (__stdcall* W98_INFOPROC)(LPSTR lpServer, LPSTR lpNet, UINT32 nLevel, LPVOID lpBuf, UINT32 nSize, LPUINT32 pTotal);
typedef void (__stdcall* NETFREEPROC)(LPVOID lpBuffer);


#pragma pack(push, 1)
typedef struct tagSHAREINFO98 {
	char		shi50_netname[LM20_NNLEN + 1];
	char		shi50_type;
    UINT16		shi50_flags;
	LPSTR		shi50_remark;
	LPSTR		shi50_path;
	char 		shi50_rw_password[SHPWLEN + 1];
	char 		shi50_ro_password[SHPWLEN + 1];
} SHAREINFO98, *LPSHAREINFO98;
#pragma pack(pop)

// **********************************************************************************
INT32 __stdcall TrueName(LPSTR lpTrueName, INT32 nSize, LPSTR lpShareName, BOOL bLocalOnly) {
union {
LPSHAREINFO98	p98;
LPSHARE_INFO_2	pNT;
LPVOID			pAny;
}				pInfo;
union {
NT_INFOPROC		pNT;
W98_INFOPROC	p98;
NETFREEPROC		pFree;
LPVOID			pAny;
}				pProc;
WCHAR			wcServer[128], wcName[128];
LPSTR			pLib;
char			cComputer[128], cServer[128], cName[128], cShare[MAX_PATH], c;
INT32			nRet, nRes, nLen1, nPos1, nLen2, nPos2;
UINT32			nTotal;
HANDLE			hLib;
BOOL			bWin98;

	nLen1 = StrCpy(cShare, lpShareName);
	if (lpTrueName) lpTrueName[0] = 0;
	else return 0;
	if (!nLen1) return 0;
	nRet = 0;
	if ((cShare[0] == '\\') && (cShare[1] == '\\')) {
		nPos1 = ChrInStr(cShare, '\\', 2, MAX_SIGNED32, FALSE);
		if (nPos1 > 2) {
			nLen2 = StrCpyN(cServer, cShare, min(nPos1 + 1, sizeof(cServer)));
			nPos2 = ChrInStr(cShare, '\\', nPos1 + 1, MAX_SIGNED32, FALSE);
			if (nPos2 < 0) nPos2 = nLen1;
			if (!(nLen1 = StrCpyN(cName, &cShare[nPos1 + 1], min(nPos2 - nPos1, sizeof(cName))))) return 0;
			if (bLocalOnly) {
				nRes = sizeof(cComputer);
				GetComputerName(cComputer, &nRes);
				if (StrICmp(cComputer, &cServer[2])) return 0;
			}
			if ((g_sWinVersion.Major == 4) && (g_sWinVersion.Build & 0x8000)) {
				pLib = "svrapi.dll";
				bWin98 = TRUE;
				StrUpr(cServer);
				StrUpr(cName);
			}
			else {
				pLib = "netapi32.dll";
				bWin98 = FALSE;
				MultiByteToWideChar(CP_ACP, 0, &cServer[2], nLen2 - 1, wcServer, sizeof(wcServer) >> 1);
				MultiByteToWideChar(CP_ACP, 0, cName, nLen1 + 1, wcName, sizeof(wcName) >> 1);
			}
			hLib = LoadLibrary(pLib);
			if (hLib) {
				pProc.pAny = GetProcAddress(hLib, "NetShareGetInfo");
				if (pProc.pAny) {
					if (bWin98) {
						nTotal = 0;
						nRes = pProc.p98(cServer, cName, 50, NULL, 0, &nTotal);
						if ((nRes == NERR_BufTooSmall) && nTotal) {
							pInfo.pAny = GetMem(GMM_DEFAULT, nTotal);
							if (pInfo.pAny) {
								nRes = pProc.p98(cServer, cName, 50, pInfo.pAny, nTotal, &nTotal);
								if (!nRes) {
									nRet = StrCpyN(lpTrueName, pInfo.p98->shi50_path, nSize);
								}
								FreeMem(pInfo.pAny);
							}
						}
					}
					else {
						pInfo.pAny = NULL;
						nRes = pProc.pNT(wcServer, wcName, 2, (LPBYTE *) &pInfo);
						if (!nRes && pInfo.pAny) {
							nRet = WideCharToMultiByte(CP_ACP, 0, pInfo.pNT->shi2_path, -1, lpTrueName, nSize, NULL, NULL);
							if (nRet) nRet--;
						}
						if (pInfo.pAny) {
							pProc.pAny = GetProcAddress(hLib, "NetApiBufferFree");
							if (pProc.pAny) pProc.pFree(pInfo.pAny);
						}
					}
				}
				FreeLibrary(hLib);
				if (nRet && cShare[nPos2]) {
					if (lpTrueName[nRet - 1] == '\\') nPos2++;
					nRet = StrCatN(lpTrueName, &cShare[nPos2], nSize);
				}
			}

		}
	}
	else {
		c = ChrUpr(cShare[0]);
		if ((c >= 'A') && (c <= 'Z') && (cShare[1] == ':')) nRet = StrCpy(lpTrueName, cShare);
	}
	return nRet;
}
