/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - updateinibuf.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include "private.h"
// **********************************************************************************
void __stdcall pUpdateIniBuf(LPSTR *lpIniBuf, LPINIBUFINFO lpInfo) {
LPSTR		pBuf, pNew;
BOOL		bOK;
INT32		nMemSize, nTxtSize, nInsSize, nDelta, nLen;

	pBuf = *lpIniBuf;
	if (lpInfo->nValLen) {
		nInsSize = lpInfo->nValLen + 2;
		if (!lpInfo->pSect) nInsSize += lpInfo->nSectLen + 4;
	}
	else nInsSize = 0;
	nTxtSize = lpInfo->nTxtLen + 1 + nInsSize - lpInfo->nDelLen;
	nMemSize = MemSize(pBuf);
	bOK = TRUE;
	if (nTxtSize > nMemSize) {
		pNew = ModifyMem(pBuf, GMM_DEFAULT, nTxtSize + TXT_EXTRABUFSIZE);
		if (pNew) {
			nDelta = pNew - pBuf;
			lpInfo->pDst += nDelta;
			lpInfo->pBufEnd += nDelta;
			*lpIniBuf = pBuf = pNew;
		}
		else bOK = FALSE;
	}
	if (bOK && (nInsSize || lpInfo->nDelLen)) {
		lpInfo->nTxtLen += nInsSize - lpInfo->nDelLen;
		if (nInsSize != lpInfo->nDelLen) {
			MemMove(lpInfo->pDst + nInsSize, lpInfo->pDst + lpInfo->nDelLen, lpInfo->pBufEnd - lpInfo->pDst - lpInfo->nDelLen + 1);
		}
		if (nInsSize) {
			nLen = (lpInfo->pSect) ? 0 : StrPrint(lpInfo->pDst, "[%s]\r\n", lpInfo->cSect);
			nLen += StrPrint(&lpInfo->pDst[nLen], "%s\r", lpInfo->cVal);
			lpInfo->pDst[nLen] = '\n';
		}
	}
}