/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - utf8toansi.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
INT32 __stdcall Utf8ToAnsi(LPSTR lpDst, INT32 nMaxDst, LPSTR lpSrc, INT32 nMaxSrc, LPINT32 lpSrcSize) {
INT32	nLen, nSize;
LPWSTR	pTemp;

	if (nMaxDst) {
		if (!lpDst) return -1;
		*lpDst = '\0';
	}
	nLen = StrLenX(lpSrc, nMaxSrc);
	if (lpSrcSize) {
		nSize = nLen;
		if (nSize < nMaxSrc) nSize++;
		*lpSrcSize = nSize;
	}
	if (!nLen) return 0;
	pTemp = GetMem(GMM_DEFAULT, (nLen + 1) << 1);
	nSize = MultiByteToWideChar(CP_UTF8, 0, lpSrc, nLen, pTemp, nLen);
	if (nSize) {
		pTemp[nSize] = 0;
		nLen = WideCharToMultiByte(CP_ACP, 0, pTemp, -1, lpDst, nMaxDst, NULL, NULL);
	}
	else nLen = 0;
	FreeMem(pTemp);
	return nLen - 1;
}
