/********************************************************************
 * Copyright (c) 2011-19 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - waitforzero.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
void __stdcall WaitForZero(LPVOID lpAnyInt, UINT32 nTimeOut) {
LPTIDDATA	pTid;
BOOL		bBreak;
UINT32		nStart, nDelta;

	pTid = _getptd();
	if (nTimeOut) nStart = GetTickCount();
	pTid->bInDoEvents = TRUE;
	bBreak = FALSE;
	do {
		if (lpAnyInt && !(*(LPINT32) lpAnyInt)) bBreak = TRUE;
		if (nTimeOut) {
			nDelta = GetTickCount() - nStart;
			if (nDelta >= nTimeOut) bBreak = TRUE;
		}
		if (!bBreak) Sleep(0);
	} while (!bBreak);
	pTid->bInDoEvents = FALSE;
}
