/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - widechartoansi.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
INT32 __stdcall WideCharToAnsi(LPSTR lpDst, INT32 nMaxDst, LPWSTR lpwSrc, INT32 nMaxSrc, INT32 nMode, LPINT32 lpSrcSize) {
INT32	nLen, nSize;

	if (nMaxDst) {
		if (!lpDst) return -1;
	}
	nMaxSrc >>= 1;
	nLen = WStrLenX(lpwSrc, nMaxSrc);
	if (lpSrcSize) {
		nSize = nLen;
		if (nSize < nMaxSrc) nSize++;
		*lpSrcSize = nSize << 1;
	}
	if (!nLen) return 0;
	switch (nMode) {
	case WCTA_LE:
		break;
	case WCTA_BE:
		WStrSwap(lpwSrc, nLen);
		break;
	case WCTA_BOM:
		if (*lpwSrc == BOM_BE) WStrSwap(lpwSrc, nLen);
		else if (*lpwSrc != BOM_LE) return -1;
		lpwSrc++;
		nLen--;
		if (!nLen) return 0;
		break;
	default:
		return -1;
	}
	nLen = WideCharToMultiByte(CP_ACP, 0, lpwSrc, nLen, lpDst, nMaxDst, NULL, NULL);
	if (nLen) lpDst[nLen] = '\0';
	else nLen--;
	return nLen;
}
