/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - dlgfile.c												*
 ********************************************************************/
// #define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
#pragma pack(push, 1)
typedef struct tagHOOKINFO {
	UINT32			LVCmd;
	TESTRESULTPROC	TestResult;
} HOOKINFO, *LPHOOKINFO;
#pragma pack(pop)
// **********************************************************************************
static BOOL CALLBACK OFNHookProc(HWND hDlg, UINT32 uMsg, WPARAM wParam, LPARAM lParam) {
LPOFNOTIFY	lpofn;
LPHOOKINFO	lpInfo;
HWND		hWnd;
BOOL		bOK;

	switch (uMsg) {
	case WM_INITDIALOG:
		break;
	case WM_NOTIFY:
		lpofn = (LPOFNOTIFY) lParam;
		lpInfo = (LPHOOKINFO) lpofn->lpOFN->lCustData;
		hWnd = GetParent(hDlg);
		if (lpofn->hdr.code == CDN_INITDONE) {
			CenterWindow(hWnd, GetParent(hWnd));
		}
		else if (lpofn->hdr.code == CDN_FOLDERCHANGE) {
			if (lpInfo->LVCmd) {
				SendDlgItemMessage(hWnd, lst2, WM_COMMAND, lpInfo->LVCmd, 0);
				lpInfo->LVCmd = 0;
			}
		}
		else if (lpofn->hdr.code == CDN_FILEOK) {
			if (lpInfo->TestResult) {
				bOK = lpInfo->TestResult(hDlg, lpofn->lpOFN->lpstrFile);
				if (!bOK) {
					SetWindowLong(hDlg, DWL_MSGRESULT, 1);			// Don't close the dialog
					return TRUE;
				}
			}
		}
		break;
	}
	return FALSE;
}
// **********************************************************************************
static void __stdcall InitFileDlg(LPOPENFILENAME lpOfn, LPHOOKINFO lpInfo, HWND hWndOwner, LPSTR lpTitle,
						LPSTR lpFile, INT32 nSize, LPSTR lpInitDir, LPSTR lpFilter, LPSTR lpDefExt,
						UINT32 dwFlags, UINT32 dwLVCmd, TESTRESULTPROC TestResult) {
INT32	nIdx, nRes, nPos;
LPSTR	pFilter;

	MemClr(lpOfn, sizeof(OPENFILENAME));
	lpOfn->lStructSize = g_sWinVersion.Major >= 5 ? sizeof(OPENFILENAME) : OPENFILENAME_SIZE_VERSION_400;
	lpOfn->hwndOwner = hWndOwner;
	lpOfn->lpstrFile = lpFile;
	lpOfn->nMaxFile = nSize;
	lpOfn->lpstrFilter = lpFilter;
	lpOfn->lpstrTitle = lpTitle;
	lpOfn->lpstrDefExt = lpDefExt;
	nIdx = nRes = 0;
	if (lpDefExt && lpFilter) {
		pFilter = lpFilter;
		while (*pFilter) {
			nIdx++;
			pFilter += 1 + StrLen(pFilter);
			if (*pFilter) {
				nPos = StrInStr(pFilter, lpDefExt, 0, TRUE);
				if (nPos >= 0) {
					nRes = nIdx;
					break;
				}
				pFilter += 1 + StrLen(pFilter);
			}
		}
	}
	lpOfn->nFilterIndex = nRes;
	lpOfn->lpstrInitialDir = lpInitDir;
	if ((lpOfn->lpstrDefExt) && (*lpOfn->lpstrDefExt == '.')) lpOfn->lpstrDefExt++;
	lpOfn->Flags = dwFlags | OFN_ENABLEHOOK | OFN_EXPLORER;
	lpOfn->lpfnHook = OFNHookProc;
	lpOfn->FlagsEx = OFN_EX_NOPLACESBAR;
	lpInfo->TestResult = TestResult;
	lpInfo->LVCmd = dwLVCmd;
	lpOfn->lCustData = (LPARAM) lpInfo;
}
// **********************************************************************************
BOOL __stdcall SaveFileDlg(HWND hWndOwner, LPSTR lpTitle, LPSTR lpFileName, LPSTR lpInitDir,
							LPSTR lpFilter, LPSTR lpDefExt, UINT32 dwFlags, UINT32 dwLVCmd, TESTRESULTPROC TestResult) {
OPENFILENAME	ofn;
HOOKINFO		Info;

	InitFileDlg(&ofn, &Info, hWndOwner, lpTitle, lpFileName, MAX_PATH, lpInitDir, lpFilter, lpDefExt,
						dwFlags, dwLVCmd, TestResult);
	return GetSaveFileName(&ofn);
}
// **********************************************************************************
BOOL __stdcall OpenFileDlg(HWND hWndOwner, LPSTR lpTitle, LPSTR lpFileName, LPSTR lpInitDir,
							LPSTR lpFilter, LPSTR lpDefExt, UINT32 dwFlags, UINT32 dwLVCmd, TESTRESULTPROC TestResult) {
OPENFILENAME	ofn;
HOOKINFO		Info;

	InitFileDlg(&ofn, &Info, hWndOwner, lpTitle, lpFileName, MAX_PATH, lpInitDir, lpFilter, lpDefExt,
						dwFlags, dwLVCmd, TestResult);
	return GetOpenFileName(&ofn);
}
BOOL __stdcall MultiOpenDlg(HWND hWndOwner, LPSTR lpTitle, LPSTR lpFileList, INT32 nSize, LPSTR lpInitDir,
							LPSTR lpFilter, LPSTR lpDefExt, UINT32 dwFlags, UINT32 dwLVCmd, TESTRESULTPROC TestResult) {
OPENFILENAME	ofn;
HOOKINFO		Info;

	dwFlags |= OFN_ALLOWMULTISELECT | OFN_FILEMUSTEXIST;
	InitFileDlg(&ofn, &Info, hWndOwner, lpTitle, lpFileList, nSize, lpInitDir, lpFilter, lpDefExt,
						dwFlags, dwLVCmd, TestResult);
	return GetOpenFileName(&ofn);
}
