/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - dlgfolder.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include <shlobj.h>
#pragma comment(lib, "shfolder.lib")
// **********************************************************************************
static INT32 CALLBACK BFHookProc(HWND hDlg, UINT32 uMsg, LPARAM wParam, LPARAM lParam) {
LPITEMIDLIST	pidl;
char			cBuf[MAX_PATH];
BOOL			bOK;

	switch (uMsg) {
	case BFFM_INITIALIZED:
		pidl = ILCreateFromPath((LPSTR) lParam);
		SendMessage(hDlg, BFFM_SETSELECTION, 0, (LPARAM) pidl);
		ILFree(pidl);
		CenterWindow(hDlg, GetParent(hDlg));
		break;
	case BFFM_SELCHANGED:
		bOK = SHGetPathFromIDList((LPITEMIDLIST) wParam, cBuf);
		if (bOK) {
			bOK = CheckFolderName(cBuf) != CPR_INVALID;
		}
		SendMessage(hDlg, BFFM_ENABLEOK, 0, bOK);
		break;
	}
	return 0;
}
// **********************************************************************************
BOOL __stdcall BrowseFolderDlg(HWND hWndOwner, LPSTR lpTitle, LPSTR lpFolder,
								LPSTR lpRoot, BOOL bNewStyle, BOOL bEditBox) {
BROWSEINFO		bi;
LPITEMIDLIST	pidl;
LPSTR			lpWork;
INT32			cpr;
char			cRoot[MAX_PATH];
BOOL			bResult, bCoInit;

	bResult = FALSE;
	bCoInit = COM_Init();
	lpWork = GetMem(GMM_DEFAULT, MAX_PATH);
	GetFullPathName(lpFolder, MAX_PATH, lpWork, NULL);
	cpr = CheckFolderName(lpWork);
	if (cpr == CPR_INVALID) lpWork[0] = '\0';
	else FormatFolder(lpWork, cpr == CPR_ROOT);
	MemClr(&bi, sizeof(bi));
	bi.hwndOwner = hWndOwner;
	bi.lpszTitle = lpTitle;
	bi.ulFlags = BIF_RETURNONLYFSDIRS;
	if (g_sWinVersion.Major >= 5) {
		if (bNewStyle) bi.ulFlags |= BIF_NEWDIALOGSTYLE;
		if (bEditBox) bi.ulFlags |= BIF_EDITBOX;
	}
	bi.lpfn = BFHookProc;
	bi.lParam = (LPARAM) lpWork;
	if (StrLen(lpRoot)) {
		StrCpyN(cRoot, lpRoot, MAX_PATH - 1);
		cpr = CheckFolderName(cRoot);
		if (cpr != CPR_INVALID) {
			FormatFolder(cRoot, cpr == CPR_ROOT);
			bi.pidlRoot = ILCreateFromPath(cRoot);
		}
	}
	pidl = SHBrowseForFolder(&bi);
	if (bi.pidlRoot) ILFree((LPITEMIDLIST) bi.pidlRoot);
	if (pidl) {
		bResult = SHGetPathFromIDList(pidl, lpFolder);
		CoTaskMemFree(pidl);
	}
	FreeMem(lpWork);
	COM_Done(bCoInit);
	return bResult;
}
