/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - files.c												*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>

// **********************************************************************************
LPFILEIO __stdcall FOpen(LPSTR lpFileName, INT32 nMode, FILEIOPROC FileIOProc) {
LPFILEIO	pFile;
INT32		nLen;
UINT32		dwAccess, dwShare, dwCreate;

	nLen = StrLen(lpFileName);
	pFile = GetMem(GMM_CLEAR, sizeof(FILEIO) + nLen);
	if (pFile) {
		MemCpy(pFile->cName, lpFileName, nLen);
		dwShare = 0;
		if (nMode & (FOM_WRITE | FOM_REWRITE)) {
			dwAccess = GENERIC_READ | GENERIC_WRITE;
			if (nMode & FOM_SHARE) dwShare = FILE_SHARE_READ;
			dwCreate = (nMode & FOM_REWRITE) ? CREATE_ALWAYS : OPEN_ALWAYS;
		}
		else {
			dwAccess = GENERIC_READ;
			if (nMode & FOM_SHARE) dwShare = FILE_SHARE_READ | FILE_SHARE_WRITE;
			dwCreate = OPEN_EXISTING;
		}
		pFile->hFile = CreateFile(lpFileName, dwAccess, dwShare, 0, dwCreate, FA_ARCHIVE, 0);
		if (pFile->hFile == INVALID_HANDLE_VALUE) {
			pFile->nErr = GetLastError();
			SetErrorFlags(ERRF_FILE | pFile->nErr);
		}
		else {
			FSize(pFile);
			pFile->pIOProc = FileIOProc;
			if (FileIOProc) pFile->pIOProc(FCBM_OPEN, pFile, NULL, 0);
		}
	}
	return pFile;
}
// **********************************************************************************
INT32 __stdcall FClose(LPFILEIO lpFile) {
INT32	nRet;

	if (!lpFile) return 0;
	if (lpFile->hFile == INVALID_HANDLE_VALUE) nRet = ERROR_INVALID_HANDLE;
	else {
		if (lpFile->pIOProc) lpFile->pIOProc(FCBM_CLOSE, lpFile, NULL, 0);
		nRet = (!CloseHandle(lpFile->hFile)) ? GetLastError() : NO_ERROR;
	}
	if (nRet) SetErrorFlags(ERRF_FILE | nRet);
	if (lpFile->nErr) nRet = lpFile->nErr;
	FreeMem(lpFile);
	return nRet;
}
// **********************************************************************************
INT32 __stdcall FCloseEx(LPFILEIO *lpFile) {
INT32	nRet;

	if (!lpFile) return 0;
	nRet = FClose(*lpFile);
	*lpFile = NULL;
	return nRet;
}
// **********************************************************************************
UINT64 __stdcall FSize(LPFILEIO lpFile) {
INT32	nErr;

	if (!lpFile) return 0;
	if (lpFile->hFile == INVALID_HANDLE_VALUE) nErr = ERROR_INVALID_HANDLE;
	else {
		lpFile->nSizeLo = GetFileSize(lpFile->hFile, &lpFile->nSizeHi);
		nErr = (lpFile->nSizeLo == INVALID_FILE_SIZE) ? GetLastError() : NO_ERROR;
	}
	if (nErr) {
		lpFile->nSize = 0;
		if (!lpFile->nErr) lpFile->nErr = nErr;
		SetErrorFlags(ERRF_FILE | nErr);
	}
	return lpFile->nSize;
}
