/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - progress.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#define NO_SHLWAPI_STRFCNS
#define NO_SHLWAPI_REG
#define NO_SHLWAPI_STREAM
#define NO_SHLWAPI_GDI
#include <shlwapi.h>
#pragma comment(lib, "shlwapi")
// **********************************************************************************
#define IDC_STATUS0			100
#define IDC_STATUS1			101
#define IDC_STATUS2			102
#define IDC_PROGRESS0		103
#define IDC_PROGRESS1		104
#define IDC_CANCEL			105

#define	DISPLAYDELTA		10
// **********************************************************************************
static void DrawProgress(LPPROGRESSINFO lpPI, HDC hDC, LPRECT lpRect, INT32 nIndex) {
char		cBuf[256];
INT32		nWidth, nSel, nValue, nRight;
float		fValue;
BOOL		bPercent, bDraw;
RECT		rCalc, rSel, rStd, rTxt;

	MemClr(&rCalc, sizeof(rCalc));
	CopyRect(&rStd, lpRect);
	DrawEdge(hDC, &rStd, EDGE_SUNKEN, BF_RECT);
	InflateRect(&rStd, -2, -2);
	CopyRect(&rSel, &rStd);
	nWidth = rStd.right - rStd.left;
	fValue = lpPI->fValue[nIndex];
	nValue = lpPI->nValue[nIndex];
	bDraw = bPercent = (nValue >= 0) && (lpPI->nFlags & PRSF_DRAWPERCENT);
	if (bDraw) {
		nSel = rStd.bottom - rStd.top;
		CopyRect(&rTxt, &rStd);
		if (fValue < 0) {
			bPercent = FALSE;
			if (nValue >= nWidth) {
				nValue = 0;
				lpPI->nValue[nIndex] = nValue;
			}
			nSel >>= 1;
			rTxt.top += nSel >> 1;
			rTxt.bottom = rTxt.top + nSel;
			nRight = nValue + nSel;
			if (nRight > nWidth) {
				rTxt.right = rTxt.left + nRight - nWidth;
				FillRectEx(hDC, &rTxt, lpPI->crSelBack);
				ExcludeClipRect(hDC, rTxt.left, rTxt.top, rTxt.right, rTxt.bottom);
				nRight = nWidth;
			}
			rTxt.left = rStd.left + nValue;
			rTxt.right = rStd.left + nRight;
			FillRectEx(hDC, &rTxt, lpPI->crSelBack);
			ExcludeClipRect(hDC, rTxt.left, rTxt.top, rTxt.right, rTxt.bottom);
		}
		else {
			StrPrint(cBuf, "%0.1f %%", 100.0 * fValue);
			DrawText(hDC, cBuf, -1, &rCalc, DT_NOPREFIX | DT_CALCRECT);
			rTxt.left += (nWidth - rCalc.right) >> 1;
			rTxt.right = rTxt.left + rCalc.right;
			rTxt.top += (nSel - rCalc.bottom) >> 1;
			rTxt.bottom = rTxt.top + rCalc.bottom;
			ExcludeClipRect(hDC, rTxt.left, rTxt.top, rTxt.right, rTxt.bottom);
		}
	}
	if (fValue < 0) nSel = 0;
	else nSel = (INT32) (lpPI->fValue[nIndex] * nWidth + 0.5);
	rSel.right = rSel.left + nSel;
	rStd.left += nSel;
	nWidth -= nSel;
	if (nSel) FillRectEx(hDC, &rSel, lpPI->crSelBack);
	if (nWidth) FillRectEx(hDC, &rStd, lpPI->crBack);
	if (bDraw) SelectClipRgn(hDC, 0);
	if (bPercent) {
		nSel = rSel.right;
		CopyRect(&rSel, &rTxt);
		CopyRect(&rStd, &rTxt);
		nWidth = rTxt.right - rTxt.left;
		if (nSel <= rTxt.left) nSel = 0;
		else if (nSel >= rTxt.right) {
			nSel = nWidth;
			nWidth = 0;
		}
		else {
			rSel.right = nSel;
			nSel -= rSel.left;
			rStd.left = rSel.right;
			nWidth -= nSel;
		}
		if (nSel) {
			if (nWidth) ExcludeClipRect(hDC, rStd.left, rStd.top, rStd.right, rStd.bottom);
			SetBkColor(hDC, lpPI->crSelBack);
			SetTextColor(hDC, lpPI->crSelText);
			DrawText(hDC, cBuf, -1, &rTxt, DT_SINGLELINE | DT_VCENTER);
			if (nWidth) SelectClipRgn(hDC, 0);
		}
		if (nWidth) {
			if (nSel) ExcludeClipRect(hDC, rSel.left, rSel.top, rSel.right, rSel.bottom);
			SetBkColor(hDC, lpPI->crBack);
			SetTextColor(hDC, lpPI->crText);
			DrawText(hDC, cBuf, -1, &rTxt, DT_SINGLELINE | DT_VCENTER);
			if (nSel) SelectClipRgn(hDC, 0);
		}
	}
}
// **********************************************************************************
static BOOL CALLBACK DlgProgressProc(HWND hDlg, UINT32 uMsg, WPARAM wParam, LPARAM lParam) {
LPDRAWITEMSTRUCT	lpDIS;
LPPROGRESSINFO		lpPI;
LPTIDDATA			pTid;
HMENU				hMenu;
char				cBuf[MAX_PATH];
HWND				hWnd;
INT32				nWidth, nHeight, nBar, nLbl, nOffs, nMode, nLIdx, nRIdx, nCnt;
BOOL				bCenter, bExclude, bPath, bOK;
RECT				rCalc, rDraw;

	pTid = _getptd();
	lpPI = pTid->pUser;
	switch (uMsg) {
	case WM_INITDIALOG:
		lpPI->hDlg = hDlg;
		lpPI->nData = 0;
		hWnd = GetDlgItem(hDlg, IDC_STATUS0);
		cBuf[0] = 'W';
		cBuf[1] = '\0';
		MeasureText(NULL, hWnd, NULL, cBuf, &rCalc, FALSE);
		nWidth = lpPI->nWidth;
		nLbl = rCalc.bottom + 2;
		MoveWindow(hWnd, 5, 5, nWidth, nLbl, FALSE);
		nBar = ((rCalc.bottom + 9) / 5 ) * 5;
		if (lpPI->nFlags & PRSF_STATUS0_OFF) {
			nHeight = 5;
		}
		else {
			nHeight = nLbl + 10;
			if (lpPI->nFlags & PRSF_STATUS1) {
				MoveWindow(GetDlgItem(hDlg, IDC_STATUS1), 5, nHeight, nWidth, nLbl, FALSE);
				nHeight += 5 + nLbl;
			}
		}
		MoveWindow(GetDlgItem(hDlg, IDC_PROGRESS0), 5, nHeight, nWidth, nBar, FALSE);
		nHeight += 5 + nBar;
		if (lpPI->nFlags & PRSF_DBLPROGRESS) {
			MoveWindow(GetDlgItem(hDlg, IDC_PROGRESS1), 5, nHeight, nWidth, nBar, FALSE);
			nHeight += 5 + nBar;
		}
		if (lpPI->nFlags & PRSF_STATUS2) {
			MoveWindow(GetDlgItem(hDlg, IDC_STATUS2), 5, nHeight, nWidth, nLbl, FALSE);
			nHeight += 5 + nLbl;
		}
		if (lpPI->cCancel[0]) {
			MeasureText(NULL, hWnd, NULL, lpPI->cCancel, &rCalc, FALSE);
			rCalc.right =((rCalc.right + 29) / 10 ) * 10;
			rCalc.bottom = ((rCalc.bottom + 9) / 5 ) * 5;
			MoveWindow(GetDlgItem(hDlg, IDC_CANCEL), 5 + ((nWidth - rCalc.right) >> 1), nHeight, rCalc.right, rCalc.bottom, FALSE);
			nHeight += 5 + rCalc.bottom;
		}
		GetWindowSize(hDlg, &rCalc);
		GetClientRect(hDlg, &rDraw);
		nWidth += 10 + rCalc.right - rDraw.right;
		nHeight += rCalc.bottom - rDraw.bottom;
		SetWindowPos(hDlg, NULL, 0, 0, nWidth, nHeight, SWP_NOMOVE | SWP_NOZORDER);
		if ((lpPI->nFlags & (PRSF_CANCEL | PRSF_MINBOX)) == PRSF_MINBOX) {
			hMenu = GetSystemMenu(hDlg, FALSE);
			nCnt = GetMenuItemCount(hMenu);
			RemoveMenu(hMenu, nCnt - 1, MF_BYPOSITION);
		}
		CenterWindow(hDlg, GetParent(hDlg));
		SetCursorFromResource(hDlg, NULL, IDC_WAIT);
		ShowWindow(hDlg, SW_SHOWNORMAL);
		if (lpPI->hOwner) EnableWindow(lpPI->hOwner, lpPI->nFlags & PRSF_ENABLEOWNER);
		if (lpPI->nFlags & PRSF_ALWAYSTOP) SetWindowPos(hDlg, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
		return TRUE;
	case WM_DRAWITEM:
		lpDIS = (LPDRAWITEMSTRUCT)lParam;
		switch (wParam) {
		case IDC_STATUS0:
		case IDC_STATUS1:
		case IDC_STATUS2:
			nLIdx = wParam - IDC_STATUS0;
			bCenter = lpPI->nStatMode[nLIdx] & PSTM_CENTER;
			bPath = lpPI->nStatMode[nLIdx] & PSTM_PATH;
			nLIdx <<= 1;
			nRIdx = nLIdx + 1;
			MemClr(&rCalc, sizeof(rCalc));
			CopyRect(&rDraw, &lpDIS->rcItem);
			nWidth = rDraw.right - rDraw.left;
			nHeight = rDraw.bottom - rDraw.top;
			nMode = DT_NOPREFIX | DT_VCENTER | DT_SINGLELINE;
			hWnd = GetDlgItem(hDlg, wParam);
			bExclude = FALSE;
			if (lpPI->cStatus[nRIdx][0] && !bCenter) {
				MeasureText(lpDIS->hDC, hWnd, NULL, lpPI->cStatus[nRIdx], &rCalc, FALSE);
				if (rCalc.right > nWidth) rCalc.right = nWidth;
				nOffs = (nHeight - rCalc.bottom) >> 1;
				rDraw.top += nOffs;
				rDraw.bottom = rDraw.top + rCalc.bottom;
				rDraw.left = rDraw.right - rCalc.right;
				DrawText(lpDIS->hDC, lpPI->cStatus[nRIdx], -1, &rDraw, nMode | DT_RIGHT);
				nWidth -= rCalc.right;
				if (nWidth > 10) nWidth -=10;
				bExclude = TRUE;
				ExcludeClipRect(lpDIS->hDC, rDraw.left, rDraw.top, rDraw.right, rDraw.bottom);
				CopyRect(&rDraw, &lpDIS->rcItem);
			}
			if (nWidth && lpPI->cStatus[nLIdx][0]) {
				StrCpy(cBuf, lpPI->cStatus[nLIdx]);
				MeasureText(lpDIS->hDC, hWnd, NULL, cBuf, &rCalc, FALSE);
				nOffs = (nHeight - rCalc.bottom) >> 1;
				rDraw.top += nOffs;
				rDraw.bottom = rDraw.top + rCalc.bottom;
				if ((nWidth < rCalc.right) && bPath) {
					bOK = PathCompactPath(lpDIS->hDC, cBuf, nWidth);
					if (bOK) MeasureText(lpDIS->hDC, hWnd, NULL, cBuf, &rCalc, FALSE);
					else StrCpy(cBuf, lpPI->cStatus[nLIdx]);
				}
				if (rCalc.right > nWidth) rCalc.right = nWidth;
				if (bCenter) {
					nMode |= DT_CENTER;
					rDraw.left += (nWidth - rCalc.right) >> 1;
				}
				else nMode |= DT_LEFT;
				rDraw.right = rDraw.left + rCalc.right;
				DrawText(lpDIS->hDC, cBuf, -1, &rDraw, nMode);
				bExclude = TRUE;
				ExcludeClipRect(lpDIS->hDC, rDraw.left, rDraw.top, rDraw.right, rDraw.bottom);
			}
			FillRectEx(lpDIS->hDC, &lpDIS->rcItem, GetBkColor(lpDIS->hDC));
			if (bExclude) SelectClipRgn(lpDIS->hDC, 0);
			break;
		case IDC_PROGRESS0:
		case IDC_PROGRESS1:
			DrawProgress(lpPI, lpDIS->hDC, &lpDIS->rcItem, wParam - IDC_PROGRESS0);
		}
		return TRUE ;
	case WM_CLOSE:
		wParam = IDC_CANCEL;
	case WM_COMMAND:
		if ((wParam == IDC_CANCEL) || (wParam == IDCANCEL)) {
			if (lpPI->lpCancel) *lpPI->lpCancel = TRUE;
		}
		break;
	case WM_SK_SHOW:
		if (wParam == SW_RESTORE) {
			EnableWindow(lpPI->hOwner, lpPI->nFlags & PRSF_ENABLEOWNER);
			lpPI->nFlags &= ~PRSF_MINIMIZED;
			ShowWindow(hDlg, SW_SHOWNORMAL);
			SetForegroundWindow(hDlg);
		}
		return TRUE;
	case WM_SIZE:
		if (wParam == SIZE_MINIMIZED) {
			lpPI->nFlags |= PRSF_MINIMIZED;
			ShowWindow(hDlg, SW_HIDE);
			EnableWindow(lpPI->hOwner, TRUE);
			SendNotifyMessage(lpPI->hOwner, WM_SK_SHOW, SW_MINIMIZE, (LPARAM) hDlg);
		}
		return TRUE;
	case WM_SK_PAINT:
		UpdateDlgWindow(hDlg, wParam, FALSE);
		return TRUE;
	case WM_SK_CLOSE:
		SetCursorFromResource(lpPI->hDlg, NULL, IDC_ARROW);
		DestroyWindow(hDlg);
		return TRUE;
	case WM_DESTROY:
		PostQuitMessage(0);
		return TRUE ;
	} // end switch
	return FALSE ;
}
// **********************************************************************************
static UINT32 WINAPI ProgressThreadProc(LPPROGRESSINFO lpPI) {
LPDLGTEMPLATE		pDt;
LPDLGITEMTEMPLATE	pDit;
LPVOID				pBuf;
LPWORD				pWord;
INT32				i, nChar, nRet;
LPTIDDATA			pTid;
MSG					Msg;

	pBuf = GetMem(GMM_CLEAR, 2048);						// It's more than enough
	pDt = AlignPtr4(pBuf);
	pDt->style = WS_POPUP | WS_BORDER | WS_CAPTION | DS_MODALFRAME;
	if (lpPI->hOwner && (lpPI->nFlags & PRSF_MINBOX)) pDt->style |= WS_MINIMIZEBOX | WS_SYSMENU;
	pDt->cx = 200;
	pDt->cy = 5;
	pWord = (LPWORD) (pDt + 1);
	pWord += 2;											// No menu, default class
	nChar = MultiByteToWideChar(CP_ACP, 0, lpPI->cTitle, -1, (LPWSTR) pWord, sizeof(lpPI->cTitle));
	pWord += nChar;
	if (lpPI->nFontSize) {
		*pWord++ = lpPI->nFontSize;
		nChar = MultiByteToWideChar(CP_ACP, 0, lpPI->cFontName, -1,  (LPWSTR) pWord, sizeof(lpPI->cFontName));
		pWord += nChar;
		pDt->style |= DS_SETFONT;
	}
	for (i = IDC_STATUS0; i <= IDC_CANCEL; i++) {
		switch (i) {
		case IDC_STATUS0:
			break;
		case IDC_STATUS1:
			if (lpPI->nFlags & PRSF_STATUS0_OFF) lpPI->nFlags &= ~PRSF_STATUS1;
			if (!(lpPI->nFlags & PRSF_STATUS1)) continue;
			break;
		case IDC_STATUS2:
			if (!(lpPI->nFlags & PRSF_STATUS2)) continue;
			break;
		case IDC_CANCEL:
			if (!lpPI->cCancel[0]) continue;
			pDt->style |= WS_SYSMENU;
			lpPI->nFlags |= PRSF_CANCEL;
			break;
		case IDC_PROGRESS1:
			if (!(lpPI->nFlags & PRSF_DBLPROGRESS)) continue;
			break;
		}
		pDit = AlignPtr4(pWord);
		pDit->x  = 5; 
		pDit->y  = pDt->cy;
		pDit->cx = 190;
		pDit->cy = 20;
		pDit->id = i;
		pDt->cy += 25;
		pWord = (LPWORD)(pDit + 1);
		*pWord++ = 0xFFFF;
		if (i == IDC_CANCEL) {
			pDit->style = WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON;
			*pWord++ = 0x0080;							// Button
			nChar = MultiByteToWideChar(CP_ACP, 0, lpPI->cCancel, -1,  (LPWSTR) pWord, sizeof(lpPI->cCancel));
			pWord += nChar;
		}
		else {
			pDit->style = WS_CHILD | WS_VISIBLE | SS_OWNERDRAW;
			if ((i == IDC_STATUS0) && (lpPI->nFlags & PRSF_STATUS0_OFF)) pDit->style &= ~WS_VISIBLE;
			*pWord++ = 0x0082;							// Static class
			pWord += 2;									// No creation data
		}
		pDt->cdit++;
	}
	pTid = _getptd();
	pTid->pUser = lpPI;
	if (pTid->hDlg = CreateDialogIndirectParam(NULL, pBuf, lpPI->hOwner, DlgProgressProc, (LPARAM) lpPI)) {
		while (GetMessage(&Msg, NULL, 0, 0)) ProcessMessage(&Msg);
		nRet = Msg.wParam;
	}
	else nRet = -1;
	lpPI->nData = 0;
	FreeMem(pBuf);
	if (lpPI->hOwner) {
		EnableWindow(lpPI->hOwner, TRUE);
		SetForegroundWindow(lpPI->hOwner);
	}
	lpPI->hDlg = NULL;
	return nRet;
}
// **********************************************************************************
LPPROGRESSINFO __stdcall ProgressOpen(HWND hWndOwner, INT32 nFontSize, LPSTR lpFontName, LPSTR lpTitle,
							LPSTR lpCancel, LPBOOL lpbCancel, INT32 nFlags, INT32 nRound0, INT32 nProgressWidth) {
LPPROGRESSINFO	pPI;
INT32			i;
HANDLE			hThread;
RECT			rcClient;

	pPI = GetMem(GMM_CLEAR, sizeof(PROGRESSINFO));
	pPI->hOwner = hWndOwner;
	if (nProgressWidth < 10) {
		if (hWndOwner) i = 1;
		else {
			hWndOwner = GetDesktopWindow();
			i = 2;
		}
		GetClientRect(hWndOwner, &rcClient);
		nProgressWidth = rcClient.right >> i;
	}
	pPI->nWidth = ((nProgressWidth + 9) / 10) * 10;
	pPI->nFontSize = nFontSize;
	StrFromRes(pPI->cFontName, lpFontName, PRS_FONTLEN);
	StrFromRes(pPI->cCancel, lpCancel, PRS_CANCELLEN);
	StrFromRes(pPI->cTitle, lpTitle, PRS_TITLELEN);
	pPI->lpCancel = lpbCancel;
	if (lpbCancel) *lpbCancel = FALSE;
	pPI->nFlags = nFlags & PRSF_FLAGMASK;
	pPI->nRound[0] = nRound0 > 0 ? nRound0 : 1000;
	pPI->nRound[1] = 1000;
	pPI->crBack = GetSysColor(COLOR_WINDOW);
	pPI->crText = GetSysColor(COLOR_WINDOWTEXT);
	pPI->crSelBack = GetSysColor(COLOR_HIGHLIGHT);
	pPI->crSelText = GetSysColor(COLOR_HIGHLIGHTTEXT);
	pPI->nTickDelta = DISPLAYDELTA;
	pPI->nTick = GetTickCount();
	pPI->nData = pPI->nValue[0] = pPI->nValue[1] = -1;
	hThread = SimpleThread(ProgressThreadProc, pPI);
	if (hThread) {
		while ((pPI->nData == -1) && !pPI->hDlg) {
			DoEvents(NULL, 1, NULL);
		}
	}
	return pPI;
}
// **********************************************************************************
LPVOID __stdcall ProgressClose(LPPROGRESSINFO lpPI) {

	if (lpPI && lpPI->hDlg) {
		SendNotifyMessage(lpPI->hDlg, WM_SK_CLOSE, 0, 0);
		DoEvents(&lpPI->hDlg, 0, NULL);
		if (lpPI->hOwner) {
			EnableWindow(lpPI->hOwner, TRUE);
			SetForegroundWindow(lpPI->hOwner);
		}
	}
	FreeMem(lpPI);
	return NULL;
}
// **********************************************************************************
BOOL __stdcall ProgressSetText(LPPROGRESSINFO lpPI, INT32 nIndex, INT32 nMode, LPSTR lpText) {
INT32	nTxtIdx;
BOOL	bUpdate;	

	bUpdate = FALSE;
	if (lpPI && lpPI->hDlg && (nIndex < PRS_STATUS)) {
		nTxtIdx = nIndex << 1;
		if (nMode & PSTM_RIGHT) nTxtIdx++;
		else {
			if (lpPI->nStatMode[nIndex] != nMode) bUpdate = TRUE;
			lpPI->nStatMode[nIndex] = nMode;
		}
		if (StrCmp(lpPI->cStatus[nTxtIdx], lpText) != 0) {
			bUpdate = TRUE;
			StrCpyN(lpPI->cStatus[nTxtIdx], lpText, PRS_STATUSLEN);
		}
		nIndex += IDC_STATUS0;
		switch (nIndex) {
		case IDC_STATUS0:
			bUpdate = bUpdate && ((lpPI->nFlags & PRSF_STATUS0_OFF) == 0);
			break;
		case IDC_STATUS1:
			bUpdate = bUpdate && (lpPI->nFlags & PRSF_STATUS1);
			break;
		case IDC_STATUS2:
			bUpdate = bUpdate && (lpPI->nFlags & PRSF_STATUS2);
			break;
		}
		if (bUpdate) SendNotifyMessage(lpPI->hDlg, WM_SK_PAINT, nIndex, 0);
	}
	return bUpdate;
}
// **********************************************************************************
BOOL __stdcall ProgressSetColor(LPPROGRESSINFO lpPI, COLORREF crBack, COLORREF crText, COLORREF crSelBack, COLORREF crSelText) {
BOOL	bUpdate;

	bUpdate = FALSE;
	if (lpPI && lpPI->hDlg) {
		if (lpPI->crBack != crBack) {
			lpPI->crBack = crBack;
			bUpdate = TRUE;
		}
		if (lpPI->crText != crText) {
			lpPI->crText = crText;
			bUpdate = TRUE;
		}
		if (lpPI->crSelBack != crSelBack) {
			lpPI->crSelBack = crSelBack;
			bUpdate = TRUE;
		}
		if (lpPI->crSelText != crSelText) {
			lpPI->crSelText = crSelText;
			bUpdate = TRUE;
		}
		if (bUpdate) {
			SendNotifyMessage(lpPI->hDlg, WM_SK_PAINT, IDC_PROGRESS0, 0); 
			if (lpPI->nFlags & PRSF_DBLPROGRESS) SendNotifyMessage(lpPI->hDlg, WM_SK_PAINT, IDC_PROGRESS1, 0);
		}
	}
	return bUpdate;
}
// **********************************************************************************
BOOL __stdcall ProgressSetValue(LPPROGRESSINFO lpPI, INT32 nIndex, float fValue) {
INT32	nVal, nTick, nDlt;
BOOL	bRet;

	bRet = FALSE;
	if (lpPI && lpPI->hDlg) {
		nIndex = nIndex & 1;
		lpPI->fValue[nIndex] = fValue;
		nTick = GetTickCount();
		if ((fValue < 0) && !nIndex) {
			nVal = lpPI->nValue[nIndex];
			nDlt = nTick - lpPI->nTick;
			if ((nDlt >= lpPI->nTickDelta) || (nVal < 0)) nVal++;
		}
		else nVal = (INT32) (fValue * lpPI->nRound[nIndex] + 0.5);
		if (lpPI->nValue[nIndex] != nVal) {
			if (!nIndex) lpPI->nTick = nTick;
			lpPI->nValue[nIndex] = nVal;
			SendNotifyMessage(lpPI->hDlg, WM_SK_PAINT, IDC_PROGRESS0 + nIndex, 0);
			bRet = TRUE;
		}
	}
	return bRet;
}
// **********************************************************************************
INT32 __stdcall ProgressSetTickDelta(LPPROGRESSINFO lpPI, INT32 nDelta) {
INT32	nRet;

	if (!lpPI) return 0;
	nRet = 0;
	if (lpPI->hDlg) {
		nRet = lpPI->nTickDelta;
		lpPI->nTickDelta = nDelta;
	}
	return nRet;
}
