/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - strsort.c												*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
static INT32 __stdcall AddItem(LPSORTINFO lpSort, LPSTR lpStr, LPVOID lpInfo, INT32 nPos) {
INT32	nLen, nCnt, nDlt, nOfs;

	if (nPos--) {
		nCnt = lpSort->nCount;
		if (lpSort->nMaxCnt == nCnt) {
			nDlt = max(nCnt >> 3, 8);
			if (!ModifyMemEx(&lpSort->pOffset, GMM_CLEAR, (lpSort->nMaxCnt + nDlt) * sizeof(INT32))) return -1;
			lpSort->nMaxCnt += nDlt;
		}
		nOfs = lpSort->nActSize;
		nLen = AlignLen4(StrLen(lpStr) + 1 + lpSort->nInfoSize);
		if ((nOfs + nLen) > lpSort->nMaxSize) {
			nDlt = max(nLen, lpSort->nMaxSize >> 3);
			if (!ModifyMemEx(&lpSort->pString, GMM_CLEAR, lpSort->nMaxSize + nDlt)) return -1;
			lpSort->nMaxSize += nDlt;
		}
		lpSort->nCount++;
		if (lpSort->nInfoSize && lpInfo) MemCpy(lpSort->pString + nOfs, lpInfo, lpSort->nInfoSize);
		nOfs += lpSort->nInfoSize;
		StrCpy(lpSort->pString + nOfs, lpStr);
		lpSort->nActSize += nLen;
		if (nPos < nCnt) MemMove(&lpSort->pOffset[nPos + 1], &lpSort->pOffset[nPos], (nCnt - nPos) * sizeof(INT32));
		lpSort->pOffset[nPos] = nOfs;
	}
	return nPos;
}
// **********************************************************************************
BOOL __stdcall Sort_Init(LPSORTINFO lpSort, INT32 nBufSize, INT32 nMaxCnt, INT32 nXInfoSize, SORTCMPPROC CmpProc) {

	if (lpSort) {
		MemClr(lpSort, sizeof(SORTINFO));
		lpSort->pCmpProc = CmpProc;
		lpSort->nMaxCnt = (nMaxCnt > 0) ? nMaxCnt : 8;
		lpSort->pOffset = GetMem(GMM_CLEAR, lpSort->nMaxCnt * sizeof(INT32));
		lpSort->nMaxSize = (nBufSize > 0) ? AlignLen4(nBufSize) : 256;
		lpSort->pString = GetMem(GMM_CLEAR, lpSort->nMaxSize);
		lpSort->nInfoSize = nXInfoSize;
	}
	return lpSort && lpSort->pString && lpSort->pOffset;
}
// **********************************************************************************
void __stdcall Sort_Done(LPSORTINFO lpSort) {

	if (lpSort) {
		FreeMem(lpSort->pString);
		FreeMem(lpSort->pOffset);
		MemClr(lpSort, sizeof(SORTINFO));
	}
}
// **********************************************************************************
void __stdcall Sort_Copy(LPSORTINFO lpDst, LPSORTINFO lpSrc, BOOL bDone, BOOL bRearrange) {
SORTINFO	siTemp;
INT32		i;
LPSTR		pItem, pInfo;

	if (!lpDst) {
		MemCpy(&siTemp, lpSrc, sizeof(SORTINFO));
		lpDst = lpSrc;
		lpSrc = &siTemp;
	}
	else {
		if (bDone) Sort_Done(lpDst);
		MemCpy(lpDst, lpSrc, sizeof(SORTINFO));
		MemClr(&siTemp, sizeof(SORTINFO));
	}
	lpDst->pOffset = GetMem(GMM_DEFAULT, lpDst->nMaxCnt * sizeof(INT32));
	lpDst->pString = GetMem(GMM_DEFAULT, lpDst->nMaxSize);
	if ((lpDst->pOffset) && (lpDst->pString)) {
		if (bRearrange) {
			lpDst->nCount = lpDst->nActSize = 0;
			for (i = 0; i < lpSrc->nCount; i++) {
				pItem = lpSrc->pString + lpSrc->pOffset[i];
				pInfo = pItem - lpSrc->nInfoSize;
				AddItem(lpDst, pItem, pInfo, i + 1);
			}
		}
		else {
			MemCpy(lpDst->pOffset, lpSrc->pOffset, lpDst->nCount * sizeof(INT32));
			MemCpy(lpDst->pString, lpSrc->pString, lpDst->nActSize);
		}
	}
	else Sort_Done(lpDst);
	Sort_Done(&siTemp);
}
// **********************************************************************************
static INT32 DoCompare(LPSORTINFO lpSort, INT32 nItem, LPSTR lpStr, LPVOID lpInfo, BOOL bText) {
INT32	nCmp;
LPSTR	lpItem;

	lpItem = lpSort->pString + lpSort->pOffset[nItem - 1];
	if (lpSort->pCmpProc) {
		nCmp = lpSort->pCmpProc(lpSort, lpItem, lpStr, lpInfo);
	}
	else {
		nCmp = bText ? StrICmp(lpItem, lpStr) : StrCmp(lpItem, lpStr);
	}
	return nCmp;
}
// **********************************************************************************
// Does not check the parameters! Call only with lpSort->nCount > 0!
static INT32 FindPos(LPSORTINFO lpSort, LPSTR lpStr, LPVOID lpInfo, BOOL bText, BOOL *bExist) {
INT32	i, hi, lo, nCnt, nCmp, nPos;

	nCnt = lpSort->nCount;
	*bExist = FALSE;
	nCmp = DoCompare(lpSort, 1, lpStr, lpInfo, bText);
	if (nCmp >= 0) {
		nPos = 1;
		if (nCmp == 0) *bExist = TRUE;
	}
	else {
		nCmp = DoCompare(lpSort, nCnt, lpStr, lpInfo, bText);
		if (nCmp < 0) nPos = nCnt + 1;
		else {
			if (nCmp == 0) lo = nCnt;
			else {
				lo = 1;
				hi = nCnt;
				while (lo <= hi) {
					i = (lo + hi) >> 1;
					nCmp = DoCompare(lpSort, i, lpStr, lpInfo, bText);
					if (nCmp < 0) lo = i + 1;
					else {
						if (nCmp == 0) {
							lo = i;
							break;
						}
						hi = i - 1;
					}
				} // while
			}
			if (nCmp == 0) {
				*bExist = TRUE;
				while (lo > 1) {
					nCmp = DoCompare(lpSort, lo - 1, lpStr, lpInfo, bText);
					if (nCmp == 0) lo--;
					else break;
				}
			}
			nPos = lo;
		}
	}
	return nPos;
}
// **********************************************************************************
INT32 __stdcall Sort_Add(LPSORTINFO lpSort, LPSTR lpStr, LPVOID lpInfo, BOOL bText, INT32 nDouble) {
INT32	i, nPos, nCmp;
BOOL	bExist;

	if (!lpSort->pString || !lpSort->pOffset) return -1;
	if (lpSort->nCount) {
		nPos = FindPos(lpSort, lpStr, lpInfo, bText, &bExist);
		if (bExist) {
			if (nDouble == 0) nPos = 0;
			else if (nDouble > 0) {
				nPos++;
				i = nPos;
				while (i <= lpSort->nCount) {
					nCmp = DoCompare(lpSort, i, lpStr, lpInfo, bText);
					if (nCmp == 0) nPos = ++i;
					else i = lpSort->nCount + 1;
				}
			}
		}
	}
	else {
		nPos = 1;
	}
	nPos = AddItem(lpSort, lpStr, lpInfo, nPos);
	return nPos;
}
// **********************************************************************************
INT32 __stdcall Sort_Find(LPSORTINFO lpSort, LPSTR lpStr, LPVOID lpInfo, BOOL bText, LPINT32 lpLast) {
INT32	i, nPos, nCmp;
BOOL	bExist;

	if (lpLast) *lpLast = -1;
	if (!lpSort->nCount || !lpSort->pString || !lpSort->pOffset) return -1;
	nPos = FindPos(lpSort, lpStr, lpInfo, bText, &bExist) - 1;
	if (bExist) {
		if (lpLast) {
			i = *lpLast = nPos;
			while (++i < lpSort->nCount) {
				nCmp = DoCompare(lpSort, i + 1, lpStr, lpInfo, bText);
				if (nCmp == 0) *lpLast = i;
				else i = lpSort->nCount;
			}
		}
		return nPos;
	}
	else return -1;
}
// **********************************************************************************
LPSTR __stdcall Sort_Item(LPSORTINFO lpSort, INT32 nIndex) {

	if ((nIndex < 0) || (nIndex >= lpSort->nCount) || !lpSort->pString || !lpSort->pOffset) return NULL;
	else return lpSort->pString + lpSort->pOffset[nIndex];
}
// **********************************************************************************
void __stdcall Sort_Clear(LPSORTINFO lpSort) {

	lpSort->nCount = lpSort->nActSize = 0;
}
// **********************************************************************************
void __stdcall Sort_Del(LPSORTINFO lpSort, INT32 nIndex) {
INT32	i, nLen, nSize, nOfs;

	if ((nIndex < 0) || (nIndex >= lpSort->nCount) || !lpSort->pString || !lpSort->pOffset) return;
	nOfs = lpSort->pOffset[nIndex];
	nLen = AlignLen4(lpSort->nInfoSize + 1 + StrLen(&lpSort->pString[nOfs]));
	lpSort->nCount--;
	if (nIndex < lpSort->nCount) MemMove(&lpSort->pOffset[nIndex], &lpSort->pOffset[nIndex + 1], (lpSort->nCount - nIndex) * sizeof(INT32));
	for (i = 0; i < lpSort->nCount; i++) {
		if (lpSort->pOffset[i] > nOfs) lpSort->pOffset[i] -= nLen;
	}
	nOfs -= lpSort->nInfoSize;
	nSize = lpSort->nActSize - (nLen + nOfs);
	if (nSize) MemMove(&lpSort->pString[nOfs], &lpSort->pString[nOfs + nLen], nSize);
	lpSort->nActSize -= nLen;
}
// **********************************************************************************
INT32 __stdcall List_Append(LPSORTINFO lpSort, LPSTR lpStr, LPVOID lpInfo) {
INT32	nRet;

	if (!lpSort->pString || !lpSort->pOffset) return -1;
	nRet = AddItem(lpSort, lpStr, lpInfo, lpSort->nCount + 1);
	return nRet;
}
// **********************************************************************************
INT32 __stdcall List_Add(LPSORTINFO lpSort, LPSTR lpStr, LPVOID lpInfo, INT32 nPos) {
INT32	nRet;

	if (!lpSort->pString || !lpSort->pOffset) return -1;
	if ((nPos < 0) || (nPos > lpSort->nCount)) return -1;
	nRet = AddItem(lpSort, lpStr, lpInfo, nPos + 1);
	return nRet;
}
// **********************************************************************************
void __stdcall Sort_Finish(LPSORTINFO lpSort) {

	if (lpSort->pOffset && (lpSort->nMaxCnt != lpSort->nCount)) {
		lpSort->nMaxCnt = lpSort->nCount;
		ModifyMemEx(&lpSort->pOffset, GMM_CLEAR, lpSort->nMaxCnt * sizeof(INT32));
	}
	if (lpSort->pString && (lpSort->nMaxSize != lpSort->nActSize)) {
		lpSort->nMaxSize = lpSort->nActSize;
		ModifyMemEx(&lpSort->pString, GMM_CLEAR, lpSort->nMaxSize);
	}
}
// **********************************************************************************
INT32 __stdcall Sort_FindPos(LPSORTINFO lpSort, LPSTR lpStr, LPVOID lpInfo, BOOL bText) {
BOOL	bExist;

	if (!lpSort->pString || !lpSort->pOffset || !StrLen(lpStr)) return -1;
	return FindPos(lpSort, lpStr, lpInfo, bText, &bExist) - 1;
}
