/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - strtodate.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
INT32 __stdcall StrToDate(LPSTR lpBuf, LPSYSTEMTIME lpDate) {
INT32		i, nScan, nVal, nLen, nRet, nDays;
BOOL		bOK;

	nRet = 0;
	nLen = StrLen(lpBuf);
	bOK = nLen > 0;
	if (lpDate) {
		for (i = 0; bOK && (i < 3); i++) {
			nVal = (INT32) IntVal(&lpBuf[nRet], NF_DEC, 0, &nScan);
			if (nScan) {
				switch (i) {
				case 0:
					if ((nVal < 0) || (nVal >= 10000)) bOK = FALSE;
					else lpDate->wYear = nVal;
					break;
				case 1:
					if ((nVal < 1) || (nVal > 12)) bOK = FALSE;
					else lpDate->wMonth = nVal;
					break;
				case 2:
					nDays = GetDaysOfMonth(lpDate->wYear, lpDate->wMonth);
					if ((nVal < 1) || (nVal > nDays)) bOK = FALSE;
					else lpDate->wDay = nVal;
					break;
				}
				nRet += nScan;
				if (i < 2) nRet++;
				if (nRet > nLen) bOK = FALSE;
			}
			else bOK = FALSE;
		}
		if (bOK) {
			nDays = DateToDay(0, lpDate);
			DayToDate(nDays, 0, lpDate);
		}
		else {
			nRet = lpDate->wYear = lpDate->wMonth = lpDate->wDay = lpDate->wDayOfWeek = 0;
		}
	}
	else bOK = FALSE;
	return nRet;
}
