/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - strtotime.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
INT32 __stdcall StrToTime(LPSTR lpBuf, LPSYSTEMTIME lpTime) {
INT32		i, nScan, nVal, nLen, nRet;
BOOL		bOK;

	nRet = 0;
	nLen = StrLen(lpBuf);
	bOK = nLen > 0;
	if (lpTime) {
		for (i = 0; bOK && (i < 3); i++) {
			nVal = (INT32) IntVal(&lpBuf[nRet], NF_DEC, 0, &nScan);
			if (nScan) {
				switch (i) {
				case 0:
					if ((nVal < 0) || (nVal > 23)) bOK = FALSE;
					else lpTime->wHour = nVal;
					break;
				case 1:
				case 2:
					if ((nVal < 0) || (nVal > 59)) bOK = FALSE;
					else {
						if (i == 1) lpTime->wMinute = nVal;
						else lpTime->wSecond = nVal;
					}
					break;
				}
				nRet += nScan;
				if (i < 2) nRet++;
				if (nRet > nLen) bOK = FALSE;
			}
			else bOK = FALSE;
		}
		if (!bOK) {
			nRet = lpTime->wHour = lpTime->wMinute = lpTime->wSecond = 0;
		}
		lpTime->wMilliseconds = 0;
	}
	else bOK = FALSE;
	return nRet;
}
